/* src/e_sdc_ecm_err.c */
/* ====================================================================
 * Copyright (c) 1999-2018 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

/*
 * NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */

#include <stdio.h>
#include <openssl/err.h>
#include "src/e_sdc_ecm_err.h"

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR

# define ERR_FUNC(func) ERR_PACK(0,func,0)
# define ERR_REASON(reason) ERR_PACK(0,0,reason)

static ERR_STRING_DATA SDC_ECM_str_functs[] = {
    {ERR_FUNC(SDC_ECM_F_BIND), "BIND"},
    {ERR_FUNC(SDC_ECM_F_CTRL), "CTRL"},
    {ERR_FUNC(SDC_ECM_F_DBUS_CHECK_CERT), "DBUS_CHECK_CERT"},
    {ERR_FUNC(SDC_ECM_F_DBUS_CONNECT), "DBUS_CONNECT"},
    {ERR_FUNC(SDC_ECM_F_DBUS_WATCH_NAME), "DBUS_WATCH_NAME"},
    {ERR_FUNC(SDC_ECM_F_DESTROY), "DESTROY"},
    {ERR_FUNC(SDC_ECM_F_DIGEST), "DIGEST"},
    {ERR_FUNC(SDC_ECM_F_FINISH), "FINISH"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_IFACE_INIT), "GATEWAY_IFACE_INIT"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_IFACE_SET_BUS_NAME),
     "GATEWAY_IFACE_SET_BUS_NAME"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_IFACE_SET_BUS_TYPE),
     "GATEWAY_IFACE_SET_BUS_TYPE"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_IFACE_SET_INTERFACE_NAME),
     "GATEWAY_IFACE_SET_INTERFACE_NAME"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_LOAD_KEY), "GATEWAY_LOAD_KEY"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_SIGN), "GATEWAY_SIGN"},
    {ERR_FUNC(SDC_ECM_F_GATEWAY_VERIFY), "GATEWAY_VERIFY"},
    {ERR_FUNC(SDC_ECM_F_INIT), "INIT"},
    {ERR_FUNC(SDC_ECM_F_LOAD_CERT), "LOAD_CERT"},
    {ERR_FUNC(SDC_ECM_F_LOAD_CLIENT_CERT), "LOAD_CLIENT_CERT"},
    {ERR_FUNC(SDC_ECM_F_LOAD_PRIVKEY), "LOAD_PRIVKEY"},
    {ERR_FUNC(SDC_ECM_F_LOAD_PUBKEY), "LOAD_PUBKEY"},
    {ERR_FUNC(SDC_ECM_F_PARAMS_CHECK_CERT_NEW), "PARAMS_CHECK_CERT_NEW"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_METHS), "PKEY_ASN1_METHS"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_METH_INIT), "PKEY_ASN1_METH_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_BITS), "PKEY_ASN1_PUB_BITS"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_CMP), "PKEY_ASN1_PUB_CMP"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_DECODE), "PKEY_ASN1_PUB_DECODE"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_ENCODE), "PKEY_ASN1_PUB_ENCODE"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_PRINT), "PKEY_ASN1_PUB_PRINT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ASN1_PUB_SIZE), "PKEY_ASN1_PUB_SIZE"},
    {ERR_FUNC(SDC_ECM_F_PKEY_CLEANUP), "PKEY_CLEANUP"},
    {ERR_FUNC(SDC_ECM_F_PKEY_COPY), "PKEY_COPY"},
    {ERR_FUNC(SDC_ECM_F_PKEY_CTRL), "PKEY_CTRL"},
    {ERR_FUNC(SDC_ECM_F_PKEY_CTRL_STR), "PKEY_CTRL_STR"},
    {ERR_FUNC(SDC_ECM_F_PKEY_DECRYPT), "PKEY_DECRYPT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_DECRYPT_INIT), "PKEY_DECRYPT_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ENCRYPT), "PKEY_ENCRYPT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_ENCRYPT_INIT), "PKEY_ENCRYPT_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_INIT), "PKEY_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_METHS), "PKEY_METHS"},
    {ERR_FUNC(SDC_ECM_F_PKEY_METH_INIT), "PKEY_METH_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_SIGN), "PKEY_SIGN"},
    {ERR_FUNC(SDC_ECM_F_PKEY_SIGNCTX), "PKEY_SIGNCTX"},
    {ERR_FUNC(SDC_ECM_F_PKEY_SIGNCTX_INIT), "PKEY_SIGNCTX_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_SIGN_INIT), "PKEY_SIGN_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFY), "PKEY_VERIFY"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFYCTX), "PKEY_VERIFYCTX"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFYCTX_INIT), "PKEY_VERIFYCTX_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFY_INIT), "PKEY_VERIFY_INIT"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFY_RECOVER), "PKEY_VERIFY_RECOVER"},
    {ERR_FUNC(SDC_ECM_F_PKEY_VERIFY_RECOVER_INIT), "PKEY_VERIFY_RECOVER_INIT"},
    {ERR_FUNC(SDC_ECM_F_RSA_BN_MOD_EXP), "RSA_BN_MOD_EXP"},
    {ERR_FUNC(SDC_ECM_F_RSA_FINISH), "RSA_FINISH"},
    {ERR_FUNC(SDC_ECM_F_RSA_INIT), "RSA_INIT"},
    {ERR_FUNC(SDC_ECM_F_RSA_MOD_EXP), "RSA_MOD_EXP"},
    {ERR_FUNC(SDC_ECM_F_RSA_PRIV_DEC), "RSA_PRIV_DEC"},
    {ERR_FUNC(SDC_ECM_F_RSA_PRIV_ENC), "RSA_PRIV_ENC"},
    {ERR_FUNC(SDC_ECM_F_RSA_PUB_DEC), "RSA_PUB_DEC"},
    {ERR_FUNC(SDC_ECM_F_RSA_PUB_ENC), "RSA_PUB_ENC"},
    {ERR_FUNC(SDC_ECM_F_RSA_SIGN), "RSA_SIGN"},
    {ERR_FUNC(SDC_ECM_F_RSA_VERIFY), "RSA_VERIFY"},
    {ERR_FUNC(SDC_ECM_F_SET_CHECK_CERT_MODE), "SET_CHECK_CERT_MODE"},
    {0, NULL}
};

static ERR_STRING_DATA SDC_ECM_str_reasons[] = {
    {ERR_REASON(SDC_ECM_R_CLIENT_CERT_NOT_IMPLEMENTED),
     "client cert not implemented"},
    {ERR_REASON(SDC_ECM_R_DBUS_NAME_IS_VANISHED), "dbus name is vanished"},
    {ERR_REASON(SDC_ECM_R_DBUS_OPEN_FAILED), "dbus open failed"},
    {ERR_REASON(SDC_ECM_R_DISCONNECT_FAILED), "disconnect failed"},
    {ERR_REASON(SDC_ECM_R_FAILED_TO_GET_KEY_HANDLER),
     "failed to get key handler"},
    {ERR_REASON(SDC_ECM_R_FAILED_TO_SET_KEY_METHODS),
     "failed to set key methods"},
    {ERR_REASON(SDC_ECM_R_FORBIDDEN_SIGN_BEFORE_SERVER_CERT_CHECK),
     "forbidden sign before server cert check"},
    {ERR_REASON(SDC_ECM_R_FORBIDDEN_TO_TURN_CERT_CHECK_OFF_WHEN_RUN_AS_CLIENT),
     "forbidden to turn cert check off when run as client"},
    {ERR_REASON(SDC_ECM_R_GATEWAY_CERT_CHECK_FAILED),
     "gateway cert check failed"},
    {ERR_REASON(SDC_ECM_R_GATEWAY_GET_CERTIFICATE_FAILED),
     "gateway get certificate failed"},
    {ERR_REASON(SDC_ECM_R_GATEWAY_SIGN_FAILED), "gateway sign failed"},
    {ERR_REASON(SDC_ECM_R_HASH_NOT_CALCULATED), "hash not calculated"},
    {ERR_REASON(SDC_ECM_R_INIT_FAILED), "init failed"},
    {ERR_REASON(SDC_ECM_R_INVALID_CA_SIGNATURE), "invalid ca signature"},
    {ERR_REASON(SDC_ECM_R_INVALID_INPUT), "invalid input"},
    {ERR_REASON(SDC_ECM_R_INVALID_INPUT_ENGINE), "invalid input engine"},
    {ERR_REASON(SDC_ECM_R_INVALID_KEY_ID), "invalid key id"},
    {ERR_REASON(SDC_ECM_R_INVALID_KEY_TYPE), "invalid key type"},
    {ERR_REASON(SDC_ECM_R_INVALID_PKEY), "invalid pkey"},
    {ERR_REASON(SDC_ECM_R_INVALID_SSL_CONTEXT), "invalid ssl context"},
    {ERR_REASON(SDC_ECM_R_INVALID_STUNNEL_CONFIGURATION),
     "invalid stunnel configuration"},
    {ERR_REASON(SDC_ECM_R_LOAD_KEY_FAILED), "load key failed"},
    {ERR_REASON(SDC_ECM_R_LOG_OPEN_FAILED), "log open failed"},
    {ERR_REASON(SDC_ECM_R_METHOD_CALL_FAILED), "method call failed"},
    {ERR_REASON(SDC_ECM_R_NOT_IMPLEMENTED), "not implemented"},
    {ERR_REASON(SDC_ECM_R_NOT_SUPPORTED), "not supported"},
    {ERR_REASON(SDC_ECM_R_NO_MEM), "no mem"},
    {ERR_REASON(SDC_ECM_R_PARAMETER_CAST_FAILED), "parameter cast failed"},
    {ERR_REASON(SDC_ECM_R_PARAMETER_HASH_TYPE_SHOULD_BE_ZERO),
     "parameter hash type should be zero"},
    {ERR_REASON(SDC_ECM_R_VERIFICATION_FAILED), "verification failed"},
    {0, NULL}
};

#endif

#ifdef SDC_ECM_LIB_NAME
static ERR_STRING_DATA SDC_ECM_lib_name[] = {
    {0, SDC_ECM_LIB_NAME},
    {0, NULL}
};
#endif

static int SDC_ECM_lib_error_code = 0;
static int SDC_ECM_error_init = 1;

void ERR_load_SDC_ECM_strings(void)
{
    if (SDC_ECM_lib_error_code == 0)
        SDC_ECM_lib_error_code = ERR_get_next_error_library();

    if (SDC_ECM_error_init) {
        SDC_ECM_error_init = 0;
#ifndef OPENSSL_NO_ERR
        ERR_load_strings(SDC_ECM_lib_error_code, SDC_ECM_str_functs);
        ERR_load_strings(SDC_ECM_lib_error_code, SDC_ECM_str_reasons);
#endif

#ifdef SDC_ECM_LIB_NAME
        SDC_ECM_lib_name->error = ERR_PACK(SDC_ECM_lib_error_code, 0, 0);
        ERR_load_strings(0, SDC_ECM_lib_name);
#endif
    }
}

void ERR_unload_SDC_ECM_strings(void)
{
    if (SDC_ECM_error_init == 0) {
#ifndef OPENSSL_NO_ERR
        ERR_unload_strings(SDC_ECM_lib_error_code, SDC_ECM_str_functs);
        ERR_unload_strings(SDC_ECM_lib_error_code, SDC_ECM_str_reasons);
#endif

#ifdef SDC_ECM_LIB_NAME
        ERR_unload_strings(0, SDC_ECM_lib_name);
#endif
        SDC_ECM_error_init = 1;
    }
}

void ERR_SDC_ECM_error(int function, int reason, char *file, int line)
{
    if (SDC_ECM_lib_error_code == 0)
        SDC_ECM_lib_error_code = ERR_get_next_error_library();
    ERR_PUT_error(SDC_ECM_lib_error_code, function, reason, file, line);
}
